

<?php

namespace backend\controllers;

use Yii;
use backend\models\Calificacion;
use backend\models\Periodo;
use backend\models\Academico;
use backend\models\Grupo;
use backend\models\Asignatura;
use backend\models\Tercero;
use backend\models\CalificacionSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\ActiveDataProvider;
use yii\base\Model;


/**
 * CalificacionController implements the CRUD actions for Calificacion model.
 */
class CalificacionController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['post'],
                ],
            ],
        ];
    }

    /**
     * Lists all Calificacion models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new CalificacionSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionCalificaciones()
    {
        $periodo = new Periodo();

        $dataProvider = new ActiveDataProvider([
            'query' => Academico::find()->select(['tercero.id', 'academico.estudiante', 'academico.grupo'])->joinWith(['estudiantes'])->where(['<', 'tercero.estado', 3])->andWhere(['academico.grupo' => Yii::$app->request->get('grupo')]),
            'pagination' => [
                'pageSize' => 500,
            ],
        ]);
        

        $registros = Calificacion::find()->where(['grupo' => Yii::$app->request->get('grupo')])->andWhere(['asignatura' => Yii::$app->request->get('asignatura'), 'periodo' => $periodo->actual->id])->count();

        $count = count(Yii::$app->request->post('Calificacion', []));
        
        $grupo = Grupo::find()->where(['id' => Yii::$app->request->get('grupo')])->one();
        $asignatura = Asignatura::find()->where(['id' => Yii::$app->request->get('asignatura')])->one(); 

        $tipo_calificacion = $grupo->grados->tipo_calificacion;
        $calificacionxcompetencia = $grupo->grados->calificacionxcompetencia;
        $num_calificaciones_saber = $asignatura->num_calificaciones_saber;
        $num_calificaciones_ser = $asignatura->num_calificaciones_ser;    
        $por_calificaciones_saber = $asignatura->por_calificaciones_saber;
        $por_calificaciones_ser = $asignatura->por_calificaciones_ser;    
        
        $calificaciones = [new Calificacion()]; 


        for($i = 1; $i < $count; $i++) {

            $calificaciones[] = new Calificacion();
        }

        if (Model::loadMultiple($calificaciones, Yii::$app->request->post())) 
            //&& Model::validateMultiple($calificaciones))  // LA VALIDACION EN EL CONTROLLER DE CALIFICACION Y COEVALUACION GENERA CONFLICTO, SOLO EN LA VISTA LA VALIDACION   
        {
            
            foreach ($calificaciones as $calificacion) {
                  
                $reg = Calificacion::find()->select(['id'])->where(['estudiante' => $calificacion->estudiante])->andWhere(['grupo' => $calificacion->grupo, 'asignatura' => $calificacion->asignatura, 'periodo' => $periodo->actual->id])->one();
                $estudiante = Tercero::find()->where(['id' => $calificacion->estudiante])->one();


                //if(count($reg) == '0')
                if(!isset($reg))
                {   
                    
                    $model= new Calificacion;
                    
                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->saber = implode(",", $calificacion->saber);
                            $model->ser = implode(",", $calificacion->ser);
                            $model->definitiva_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                            $model->definitiva_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                            $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser;
                            
                        }
                        else // POR COMPETENCIA
                        {
                            $model->saber = implode(",", $calificacion->saber);
                            $model->ser = implode(",", $calificacion->ser);
                            $model->definitiva_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                            $model->definitiva_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                            $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser;
                            
                        }    
                    
                    
                    $model->docente = $calificacion->docente;
                    $model->estudiante = $calificacion->estudiante;
                    $model->asignatura = $calificacion->asignatura;
                    $model->grupo = $calificacion->grupo;
                    $model->periodo = $calificacion->periodo;
                        
                        if($model->save(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'danger',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' no se almacenaron en el sistema',
                            ]);
                        }
                }
                else
                {  
                    $model= Calificacion::find()->where(['id' => $reg->id])->one();


                        if ($calificacionxcompetencia == 1) // POR ASIGNATURA
                        {
                            $model->saber = implode(",", $calificacion->saber);
                            $model->ser = implode(",", $calificacion->ser);
                            
                            $model->definitiva_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                            $model->definitiva_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                            $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser;
                            

                        }
                        else // POR COMPETENCIA
                        {
                            $model->saber = implode(",", $calificacion->saber);
                            $model->ser = implode(",", $calificacion->ser);
                            
                            $model->definitiva_saber = $model->promedio($calificacion->saber, $num_calificaciones_saber, $por_calificaciones_saber);
                            $model->definitiva_ser = $model->promedio($calificacion->ser, $num_calificaciones_ser, $por_calificaciones_ser);
                            $model->definitiva_periodo = $model->definitiva_saber + $model->definitiva_ser;
                            
                        }  
                      
                    
                        if($model->update(false))
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'success',
                                'titulo' => 'Calificaciones Almacenadas',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'Las calificaciones de '.$estudiante->nombre.' se almacenaron con éxito en el sistema',
                            ]);  
                        } 
                        else
                        {
                            Yii::$app->session->addFlash('mensaje', [
                                'tipo' => 'info',
                                'titulo' => 'No hubo cambios!',
                                'icono' => 'fa fa-check-square-o',
                                'mensaje' => 'No hubo cambios en las calificaciones de '.$estudiante->nombre.' por eso no se actualizaron en el sistema',
                            ]);
                        }
                    
                }    
            }

            return $this->redirect(['docente/index']);
            
        }
        else
        {

            return $this->render('calificaciones', [
                'dataProvider' => $dataProvider,
                'periodo' => $periodo,
                'calificaciones' => $calificaciones,
                'registros' => $registros,
                'grupo' => $grupo,
                'calificacionxcompetencia' => $calificacionxcompetencia,
                'tipo_calificacion' => $tipo_calificacion,
                'num_calificaciones_saber' => $num_calificaciones_saber,
                'num_calificaciones_ser' => $num_calificaciones_ser, 
                'por_calificaciones_saber' => $por_calificaciones_saber,
                'por_calificaciones_ser' => $por_calificaciones_ser,
            ]);
        }
    } 


    public function actionView($id)
    {
        $model = $this->findModel($id);
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Calificacion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Calificacion();

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Calificacion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Calificacion model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        //$this->findModel($id)->deleteWithRelated();

        $model = $this->findModel($id);
        $model->eliminado_por = \Yii::$app->user->id;
        $model->eliminado_el = new \yii\db\Expression('NOW()');
        $model->update();

        return $this->redirect(['index']);
    }

    public function actionRestore($id)
    {
        $this->findModel($id)->restoreWithRelated();

        return $this->redirect(['index']);
    }

    
    /**
     * Finds the Calificacion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Calificacion the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Calificacion::findOne($id)) !== null) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
